<?xml version="1.0" encoding="UTF-8"?>
<!-- set the following statement to define the namespace used for the user data (as used in the xml device profile instance file)
      and then replace all occurrences of namespace xxx in this stylesheet -->
<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema" 
xmlns:fn="http://www.w3.org/2005/xpath-functions" 
xmlns:xxx="http://www.xxx.com">
	<xsl:output method="html" encoding="ISO-8859-1"/>
	<xsl:template name="userDataSection1-1">
		<xsl:param name="path"/>
		<!-- Section 1.1.14  -->
		<tr>
			<td width="35%" valign="top">1.1.14. User Data:<p/>
				<i>A user data entry</i>
			</td>
			<td width="35%" valign="top">&#160;
			</td>
			<td width="20%" valign="baseline">&#160;
			</td>
			<td width="10%" valign="baseline">
				<xsl:call-template name="methodsBox-xxx">
					<xsl:with-param name="path" select="$path/xxx:xxx/xxx:methods"/>
				</xsl:call-template>
			</td>
		</tr>
	</xsl:template>
	<xsl:template name="userDataSection1-2">
		<xsl:param name="path"/>
		<!-- Section 1.2.9  -->
		<tr>
			<td width="35%" valign="top">1.2.9. User Data:<p/>
				<i>A user data entry</i>
			</td>
			<td width="35%" valign="top">&#160;
			</td>
			<td width="20%" valign="baseline">&#160;
			</td>
			<td width="10%" valign="baseline">
				<xsl:call-template name="methodsBox-xxx">
					<xsl:with-param name="path" select="$path/xxx:xxx/xxx:methods"/>
				</xsl:call-template>
			</td>
		</tr>
	</xsl:template>
	<xsl:template name="userDataSection1-3">
		<xsl:param name="path"/>
		<!-- Section 1.3.18  -->
		<tr>
			<td width="35%" valign="top">1.3.18. User Data:<p/>
				<i>A user data entry</i>
			</td>
			<td width="35%" valign="top">&#160;
			</td>
			<td width="20%" valign="baseline">&#160;
			</td>
			<td width="10%" valign="baseline">
				<xsl:call-template name="methodsBox-xxx">
					<xsl:with-param name="path" select="$path/xxx:xxx/xxx:methods"/>
				</xsl:call-template>
			</td>
		</tr>
	</xsl:template>
	<xsl:template name="userDataSection1-4">
		<xsl:param name="path"/>
		<!-- Section 1.4.10  -->
		<tr>
			<td width="35%" valign="top">1.4.10. User Data:<p/>
				<i>A user data entry</i>
			</td>
			<td width="35%" valign="top">&#160;
			</td>
			<td width="20%" valign="baseline">&#160;
			</td>
			<td width="10%" valign="baseline">
				<xsl:call-template name="methodsBox-xxx">
					<xsl:with-param name="path" select="$path/xxx:xxx/xxx:methods"/>
				</xsl:call-template>
			</td>
		</tr>
	</xsl:template>
	<xsl:template name="userDataSection1-5">
		<xsl:param name="path"/>
		<!-- Section 1.5.9  -->
		<tr>
			<td width="35%" valign="top">1.5.9. User Data:<p/>
				<i>A user data entry</i>
			</td>
			<td width="35%" valign="top">&#160;
			</td>
			<td width="20%" valign="baseline">&#160;
			</td>
			<td width="10%" valign="baseline">
				<xsl:call-template name="methodsBox-xxx">
					<xsl:with-param name="path" select="$path/xxx:xxx/xxx:methods"/>
				</xsl:call-template>
			</td>
		</tr>
	</xsl:template>
	<xsl:template name="userDataSection1-6">
		<xsl:param name="path"/>
		<!-- Section 1.6.12  -->
		<tr>
			<td width="35%" valign="top">1.6.12. User Data:<p/>
				<i>A user data entry</i>
			</td>
			<td width="35%" valign="top">&#160;
			</td>
			<td width="20%" valign="baseline">&#160;
			</td>
			<td width="10%" valign="baseline">
				<xsl:call-template name="methodsBox-xxx">
					<xsl:with-param name="path" select="$path/xxx:xxx/xxx:methods"/>
				</xsl:call-template>
			</td>
		</tr>
	</xsl:template>
	<xsl:template name="userDataSection1-7">
		<xsl:param name="path"/>
		<!-- Section 1.7.10  -->
		<tr>
			<td width="35%" valign="top">1.7.10. User Data:<p/>
				<i>A user data entry</i>
			</td>
			<td width="35%" valign="top">&#160;
			</td>
			<td width="20%" valign="baseline">&#160;
			</td>
			<td width="10%" valign="baseline">
				<xsl:call-template name="methodsBox-xxx">
					<xsl:with-param name="path" select="$path/xxx:xxx/xxx:methods"/>
				</xsl:call-template>
			</td>
		</tr>
	</xsl:template>
	<xsl:template name="userDataSection1-8">
		<xsl:param name="path"/>
		<!-- Section 1.8.5  -->
		<tr>
			<td width="35%" valign="top">1.8.5. User Data:<p/>
				<i>A user data entry</i>
			</td>
			<td width="35%" valign="top">&#160;
			</td>
			<td width="20%" valign="baseline">&#160;
			</td>
			<td width="10%" valign="baseline">
				<xsl:call-template name="methodsBox-xxx">
					<xsl:with-param name="path" select="$path/xxx:xxx/xxx:methods"/>
				</xsl:call-template>
			</td>
		</tr>
	</xsl:template>
	<xsl:template name="userDataSection1-9">
		<xsl:param name="path"/>
		<!-- Section 1.9.11  -->
		<tr>
			<td width="35%" valign="top">1.9.11. User Data:<p/>
				<i>A user data entry</i>
			</td>
			<td width="35%" valign="top">&#160;
			</td>
			<td width="20%" valign="baseline">&#160;
			</td>
			<td width="10%" valign="baseline">
				<xsl:call-template name="methodsBox-xxx">
					<xsl:with-param name="path" select="$path/xxx:xxx/xxx:methods"/>
				</xsl:call-template>
			</td>
		</tr>
	</xsl:template>
	<xsl:template name="userDataSection1-10">
		<xsl:param name="path"/>
		<!-- Section 1.10.9  -->
		<tr>
			<td width="35%" valign="top">1.10.9. User Data:<p/>
				<i>A user data entry</i>
			</td>
			<td width="35%" valign="top">&#160;
			</td>
			<td width="20%" valign="baseline">&#160;
			</td>
			<td width="10%" valign="baseline">
				<xsl:call-template name="methodsBox-xxx">
					<xsl:with-param name="path" select="$path/xxx:xxx/xxx:methods"/>
				</xsl:call-template>
			</td>
		</tr>
	</xsl:template>
	<xsl:template name="userDataSection1-11">
		<xsl:param name="path"/>
		<!-- Section 1.11.5  -->
		<tr>
			<td width="35%" valign="top">1.11.5. User Data:<p/>
				<i>A user data entry</i>
			</td>
			<td width="35%" valign="top">&#160;
			</td>
			<td width="20%" valign="baseline">&#160;
			</td>
			<td width="10%" valign="baseline">
				<xsl:call-template name="methodsBox-xxx">
					<xsl:with-param name="path" select="$path/xxx:xxx/xxx:methods"/>
				</xsl:call-template>
			</td>
		</tr>
	</xsl:template>
	
	<xsl:template name="userDataSection1">
		<xsl:param name="path"/>
		<p/>
		<table border="1" align="center" width="90%" cellspacing="0" cellpadding="3">
			<!-- first line of table heading -->
			<tr bgcolor="yellow">
				<b>
					<th align="left" width="35%">
						<font face="Times New Roman" style="font-variant: small-caps;">
							1.13
					</font>
				</th>
				<th align="left" width="35%">Capabilities</th>
				<th align="left" width="20%">Current Value</th>
				<th align="left" width="10%">If configurable list methods</th>
			</b>
		</tr>
			<tbody>
				<!-- Section 1.13.1  -->
			</tbody>
		</table>
	</xsl:template>

	<xsl:template name="userDataSection3">
		<xsl:param name="path"/>
		<p/>
		<table border="1" align="center" width="90%" cellspacing="0" cellpadding="3">
			<tr bgcolor="yellow">
				<b>
					<th align="left" colspan="4">
						<font face="Times New Roman" style="font-variant: small-caps;">
							<big>3.12. </big>
						</font>
						<br/>Static (Steady-State) Object Number: <b></b>
						<br/>Event Object Number: <b></b>
					</th>
				</b>
			</tr>
		</table>
	</xsl:template>


	<!-- templates to put out a notes box of the capabilities column for xxx namespace  -->
	<xsl:template name="showNotesCap-xxx">
		<xsl:param name="path"/>
		<xsl:if test="$notes = 'yes'">
			<xsl:for-each select="$path/xxx:capabilities/xxx:note">
				<br/>
				<table border="0" width="100%" bgcolor="PaleGreen">
					<tbody>
						<tr>
							<td>Note: <xsl:value-of select="."/>
							</td>
						</tr>
					</tbody>
				</table>
			</xsl:for-each>
		</xsl:if>
	</xsl:template>
	<!-- templates to put out a notes box of the current value column for xxx namespace  -->
	<xsl:template name="showNotesCV-xxx">
		<xsl:param name="path"/>
		<xsl:if test="$notes = 'yes'">
			<xsl:for-each select="$path/xxx:currentValue/xxx:note">
				<br/>
				<table border="0" width="100%" bgcolor="PaleGreen">
					<tbody>
						<tr>
							<td>Note: <xsl:value-of select="."/>
							</td>
						</tr>
					</tbody>
				</table>
			</xsl:for-each>
		</xsl:if>
	</xsl:template>

	<!-- template to display methods for xxx namespace -->
	<xsl:template name="methodsBox-xxx">
		<xsl:param name="path"/>
		<xsl:if test="$path/xxx:xmlViaFileTransfer">XML via File Transfer<br/>----------------<br/>
		</xsl:if>
		<xsl:if test="$path/xxx:xmlViaOtherTransportMechanism">XML via Other Mechanism<br/>----------------<br/>
		</xsl:if>
		<xsl:if test="$path/xxx:proprietaryFileViaFileTransfer">Proprietary File via File Transfer<br/>----------------<br/>
		</xsl:if>
		<xsl:if test="$path/xxx:proprietaryFileViaOtherTransportMechanism">Proprietary File via Other Mechanism<br/>----------------<br/>
		</xsl:if>
		<xsl:if test="$path/xxx:terminal">terminal<br/>----------------<br/></xsl:if>
		<xsl:if test="$path/xxx:software">
			software <b>
				<xsl:value-of select="$path/xxx:software/xxx:name"/>
			</b>
			<xsl:if test="$path/xxx:software/xxx:version"> Vers </xsl:if><b>
				<xsl:value-of select="$path/xxx:software/xxx:version"/>
			</b>
			<br/>----------------<br/>
		</xsl:if>
		<xsl:if test="$path/xxx:direct">direct<br/>----------------<br/></xsl:if>
		<xsl:if test="$path/xxx:factory">factory<br/>----------------<br/></xsl:if>
		<xsl:if test="$path/xxx:protocol">protocol<br/>----------------<br/></xsl:if>
		<xsl:if test="$path/xxx:other">other<br/>(<xsl:value-of select="$path/xxx:other/xxx:explanation"/>)</xsl:if>
		<!-- in case there are no methods, we need a space to format the display correctly -->
		<font color="white">&#160;</font>
	</xsl:template>

</xsl:stylesheet>
